#pragma rtGlobals=1		// Use modern global access method.

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//cette macro permet de visualiser la distribution  teta2 pondre,
//pour un couple (teta1, E1) donn, et ceci dans le plan (k1, champ E) 
Macro MacroTDCS_plan(wteta1,wdteta1,wphi1,wdphi1,wenergie1,wdenergie1,wenergie2,wdenergie2,wbins,Weight)
	Variable wteta1=90
	Variable wdteta1=15// (idem Allemands...)
	Variable wphi1=-90
	Variable wdphi1=15
	Variable wenergie1=12.5
	Variable wdenergie1=10
	Variable wenergie2=12.5
	Variable wdenergie2=10
	Variable wbins=36
	string Weight=""
	Prompt wteta1, "1rst particle : theta (deg)"
	Prompt wdteta1, " Opening angle  (deg)"
	Prompt wphi1, "Phi (deg)"
	Prompt wdphi1, "Opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wbins, " Binning (number)"
	Prompt Weight, "Additional filter (wave name)"
	
	string particle1="e1" // allow  permutation  e1<-> e2
	string particle2="e2"
	Variable dp=20		// delta phi

	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS Plan procedure ============="
	timerRefNum = startMSTimer

	// Calcul Filter	
	duplicate/O/D $("thet_"+particle1), wa,wb, w1, w2,wtot
		// Electron 1 Filter
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)												// Energy filter
		OrientLight(particle1,wteta1*pi/180,wdteta1*pi/180, wphi1*pi/180, wdphi1*pi/180,w1)	// Orientation filter
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)						// Energy filter
		wa=((abs($("Dphi_"+particle1+particle2))<dp*pi/180 )%| (abs(abs($("Dphi_"+particle1+particle2))-2*pi)<dp*pi/180))  // angle filter, same half planes
		wb= (abs(abs($("Dphi_"+particle1+particle2))-pi)<dp*pi/180)  // angle filter, opposite half planes
		wtot=(wa+wb)*w1  // No filtering on the particle 2
		if (cmpstr(weight,""))   // Is there any weight filter to include (ions?)
			wtot=wtot*$(weight)
	       endif
	       
	// Make TDCS Plan   
		duplicate/O/D $("thet_"+particle2), wtet2
		// Convert particle2 spherical angle (0,Pi) into trigonometrical angle (0,2Pi)
		wtet2=wtet2*wa+(2*Pi-wtet2)*wb
		// Do histogram
		hist1 wtet2,wtot,(wbins),0.,(2*pi),0,0,0
		Hist_wtet2/=abs(sin(x))  
		duplicate/O/D  Hist_wtet2_pond Hist_wtet2_pond_D     //08/01/05
 	killwaves w1,w2,wa,wb, wtet2
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN INVERSEE  8/01/05   la mme avec les2 lectrons permuts
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//cette macro permet de visualiser la distribution  teta2 pondre,
//pour un couple (teta1, E1) donn, et ceci dans le plan (k1, champ E) 
Macro MacroTDCS_plan_inv(wteta1,wdteta1,wphi1,wdphi1,wenergie1,wdenergie1,wenergie2,wdenergie2,wbins,Weight)
	Variable wteta1=90
	Variable wdteta1=15// (idem Allemands...)
	Variable wphi1=-90
	Variable wdphi1=15
	Variable wenergie1=12.5
	Variable wdenergie1=10
	Variable wenergie2=12.5
	Variable wdenergie2=10
	Variable wbins=36
	string Weight=""
	Prompt wteta1, "1rst particle : theta (deg)"
	Prompt wdteta1, " Opening angle  (deg)"
	Prompt wphi1, "Phi (deg)"
	Prompt wdphi1, "Opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wbins, " Binning (number)"
	Prompt Weight, "Additional filter (wave name)"
	
	string particle1="e2" // allow  permutation  e1<-> e2
	string particle2="e1"
	Variable dp=20		// delta phi

	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS Plan procedure ============="
	timerRefNum = startMSTimer

	// Calcul Filter	
	duplicate/O/D $("thet_"+particle1), wa,wb, w1, w2,wtot
		// Electron 1 Filter
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)												// Energy filter
		OrientLight(particle1,wteta1*pi/180,wdteta1*pi/180, wphi1*pi/180, wdphi1*pi/180,w1)	// Orientation filter
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)						// Energy filter
		wa=((abs($("Dphi_"+particle1+particle2))<dp*pi/180 )%| (abs(abs($("Dphi_"+particle1+particle2))-2*pi)<dp*pi/180))  // angle filter, same half planes
		wb= (abs(abs($("Dphi_"+particle1+particle2))-pi)<dp*pi/180)  // angle filter, opposite half planes
		wtot=(wa+wb)*w1 // No filter on the particle2
		if (cmpstr(weight,""))   // Is there any weight filter to include (ions?)
			wtot=wtot*$(weight)
	       endif
	       
	// Make TDCS Plan   
		duplicate/O/D $("thet_"+particle2), wtet2
		// Convert particle2 spherical angle (0,Pi) into trigonometrical angle (0,2Pi)
		wtet2=wtet2*wa+(2*Pi-wtet2)*wb
		// Do histogram
		hist1 wtet2,wtot,(wbins),0.,(2*pi),0,0,0
		Hist_wtet2/=abs(sin(x))  	
		duplicate/O/D Hist_wtet2_pond  Hist_wtet2_pond_I,Hist_wtet2_pond_Tot
		Hist_wtet2_pond_Tot=Hist_wtet2_pond_D + Hist_wtet2_pond_I
 	killwaves w1,w2,wa,wb,wtet2
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN 0_PI
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
Macro MacroTDCS_0Pi(wdteta1,wenergie1,wdenergie1,wenergie2,wdenergie2,wbins,Weight)
	Variable wdteta1=20// (idem Allemands...)
	Variable wenergie1=20
	Variable wdenergie1=5
	Variable wenergie2=5
	Variable wdenergie2=3
	Variable wbins=36
	string Weight=""
	Prompt wdteta1, "1rst particle : opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wbins, " Binning (number)"
	Prompt Weight, "Additional filter (wave name)"
	
	string particle1="e1" // allow  permutation  e1<-> e2
	string particle2="e2"
	
	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS 0-Pi procedure ============="
	timerRefNum = startMSTimer
		
	// Calcul Filter
	duplicate/O/D $("thet_"+particle1), w1,w2, wtot, wtot_pi		
		// Electron 1 Filter		
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)	
		duplicate/O/D w1, w1_pi
		OrientLight(particle1,0,wdteta1*pi/180, 0, 2*pi,w1)
		OrientLight(particle1,Pi,wdteta1*pi/180, 0, 2*pi,w1_pi)	
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)
		OrientLight(particle2,0,pi, pi/2, pi/4,w2)		// special line for HD  01/07/05					
		// Full filter
		wtot=w1*w2
		wtot_pi=w1_pi*w2
		if (cmpstr(weight,""))   // Is there any weight filter to include (ions?)
			wtot=wtot*$(weight)
			wtot_pi=w1_pi*$(weight)
	       endif
	       
        // Make TDCS 0-Pi   
	duplicate/O/D $("thet_"+particle2), wtet2, wtet2_pi
	
	hist1 wtet2,wtot,(wbins),0,(pi),0,0,0
	hist1 wtet2_pi,wtot_pi,(wbins),0,(pi),0,0,0
	InvertSum(Hist_wtet2,Hist_wtet2_pi)
	//Hist_wtet2=Hist_wtet2_pi
	Ponder1D(Hist_wtet2)       
	duplicate/O/D  Hist_wtet2_pond Hist_wtet2_pond_D
 	killwaves w1,w1_pi,w2,wtot,wtot_pi,wtet2,wtet2_pi,Hist_wtet2_pi
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN 0_PI_inv  la mme avec les deux lectrons inverss  1/07/05
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
Macro MacroTDCS_0Pi_Inv(wdteta1,wenergie1,wdenergie1,wenergie2,wdenergie2,wbins,Weight)
	Variable wdteta1=20// (idem Allemands...)
	Variable wenergie1=20
	Variable wdenergie1=5
	Variable wenergie2=5
	Variable wdenergie2=3
	Variable wbins=36
	string Weight=""
	Prompt wdteta1, "1rst particle : opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wbins, " Binning (number)"
	Prompt Weight, "Additional filter (wave name)"
	
	string particle1="e2" // allow  permutation  e1<-> e2
	string particle2="e1"
	
	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS 0-Pi procedure ============="
	timerRefNum = startMSTimer
		
	// Calcul Filter
	duplicate/O/D $("thet_"+particle1), w1,w2, wtot, wtot_pi		
		// Electron 1 Filter		
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)	
		duplicate/O/D w1, w1_pi
		OrientLight(particle1,0,wdteta1*pi/180, 0, 2*pi,w1)
		OrientLight(particle1,Pi,wdteta1*pi/180, 0, 2*pi,w1_pi)	
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)
		OrientLight(particle2,0,pi, -pi/2, pi/4,w2)		// special line for HD  01/07/05							
		// Full filter
		wtot=w1*w2
		wtot_pi=w1_pi*w2
		if (cmpstr(weight,""))   // Is there any weight filter to include (ions?)
			wtot=wtot*$(weight)
			wtot_pi=w1_pi*$(weight)
	       endif
	       
        // Make TDCS 0-Pi 
       
	duplicate/O/D $("thet_"+particle2), wtet2, wtet2_pi
	hist1 wtet2,wtot,(wbins),0,(pi),0,0,0
	hist1 wtet2_pi,wtot_pi,(wbins),0,(pi),0,0,0
	InvertSum(Hist_wtet2,Hist_wtet2_pi)
	//Hist_wtet2=Hist_wtet2_pi
	Ponder1D(Hist_wtet2)       
	duplicate/O/D  Hist_wtet2_pond Hist_wtet2_pond_I
 	killwaves w1,w1_pi,w2,wtot,wtot_pi,wtet2,wtet2_pi,Hist_wtet2_pi
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PERP_DORNER
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       

//Macro TDCS_Perp_Dorner   L'lectron 1 est vertical, et l'lectron 2 est dans le plan horizontal.

Macro TDCS_Perp_Dorner(coscone,cosplan,wenergie1,wdenergie1,wenergie2,wdenergie2,wbins,weight)
	Variable coscone=0.8
	Variable cosplan=0.2
	Variable wenergie1=12.5
	Variable  wdenergie1=6
	Variable wenergie2=12.5
	Variable wdenergie2=6
	Variable wbins=36
	String weight=""
	
	TDCS_Perp_Dor(coscone,cosplan,wenergie1,wdenergie1,wenergie2,wdenergie2,wbins,weight)
	Endmacro
	
	
Function TDCS_Perp_Dor(coscone,cosplan,wenergie1,wdenergie1,wenergie2,wdenergie2,wbins,weight)	
	Variable coscone
	Variable cosplan
	Variable wenergie1
	Variable  wdenergie1
	Variable wenergie2
	Variable wdenergie2
	Variable wbins
	String weight
   	WAVE pxe1=px_e1
	WAVE pye1=py_e1
	WAVE pze1=pz_e1
	WAVE ee1=e_e1
	WAVE pxe2=px_e2
	WAVE pye2=py_e2
	WAVE pze2=pz_e2
	WAVE ee2=e_e2
	duplicate/O pxe1, w1,w1a,w1b,wtot
	
	w1a= (abs(pze1/sqrt(1000*ee1))>coscone)&&(abs(pze2/sqrt(1000*ee2))<cosplan)
	w1b= (abs(pze2/sqrt(1000*ee2))>coscone)&&(abs(pze1/sqrt(1000*ee1))<cosplan)
	w1=w1a+w1b
	w1*=(abs(ee1- wenergie1)< wdenergie1)*(abs(ee2- wenergie2)< wdenergie2)
	if (cmpstr(weight,""))   // Is there any weight filter to include (ions?)
		WAVE wion=$(weight)
		wtot=w1*wion
	else
		wtot=w1
	endif
	
	make/O/D/N=(wbins) Hist_wtet2_horiz
	SetScale/I x 0,360,"", Hist_wtet2_horiz
	Hist_wtet2_horiz=0

	Variable NPoints, K, Step=360/wbins
	Variable Norm, Angle

	K=0
	NPoints=numpnts(pxe2)
	Do
		
		if (w1a[K]*wtot[K]!=0)
				Angle=atan2(pye2[K],pxe2[K])*180/Pi	
			if (Angle<0) 
				Angle=360+Angle
			endif
			Hist_wtet2_horiz[floor(Angle/step)]+=1
		endif
		if (w1b[K]*wtot[K]!=0)
				Angle=atan2(pye1[K],pxe1[K])*180/Pi	
			if (Angle<0) 
				Angle=360+Angle
			endif
			Hist_wtet2_horiz[floor(Angle/step)]+=1
		endif
		K+=1
	While(K<NPoints)
	Hist_wtet2_horiz[0]=(Hist_wtet2_horiz[0]+Hist_wtet2_horiz[NPoints-1])/2
	Hist_wtet2_horiz[NPoints-1]=Hist_wtet2_horiz[0]
End
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												PLOT_DORNER
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//cette macro permet de visualiser la distribution de l'lectron 2 dans l'espace
// pour un couple (E1, teta1) et une nergie E2 fixs,  par un plot 2D montrant (phi2-phi1) en fonction de teta2.
Macro Plot_Dorner(wteta1,wdteta1,wenergie1,wdenergie1,wenergie2,wdenergie2,wbins,Weight)
	Variable wteta1=55
	Variable wdteta1=15
	Variable wphi1=-90
	Variable wdphi1=60
	Variable wenergie1=12.5
	Variable wdenergie1=10
	Variable wenergie2=12.5
	Variable wdenergie2=10
	Variable wbins=36
	string Weight=""
	Prompt wteta1, "1rst particle : theta (deg)"
	Prompt wdteta1, " Opening angle  (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wbins, " Binning (number)"
	Prompt Weight, "Additional filter (wave name)"
	
	string particle1="e1" // allow  permutation  e1<-> e2
	string particle2="e2"

	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start PLOT_DORNER procedure ============="
	timerRefNum = startMSTimer

	// Calcul Filter	
	duplicate/O/D $("thet_"+particle1), w1,w2, wtot	
		// Electron 1 Filter
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)												// Energy filter
		OrientLight(particle1,wteta1*pi/180,wdteta1*pi/180, wphi1*pi/180, wdphi1*pi/180,w1)	// Orientation filter
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)						// Energy filter
		// Full filter
		wtot=w1*w2
		if (cmpstr(weight,""))   // Is there any weight filter to include (ions?)
			wtot=wtot*$(weight)
	       endif
	       
	// Make PLOT_DORNER 
	
		hist2 $("thet_"+particle2),$("Dphi_"+particle1+particle2),wtot,(wbins),(wbins/2),0,pi,0.5*pi,1.5*pi,0,0,0,0
	
 	killwaves w1,w2,wtot
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS_Vert_Tim 
//----------------------------------------------------------------------------------------------------------------------------------------------

//Macro TDCS_Vert_Tim   Both electrons are in the vert plane perpendicular to the polarisation axis
Macro TDCS_Vert_Tim(wenergie1,wdenergie1,wenergie2,wdenergie2,wphi1,wdphi1, wdteta,wbins,weight)
	Variable wenergie1=12.5
	Variable wdenergie1=10
	Variable wenergie2=12.5
	Variable wdenergie2=10
	Variable wphi1=-90
	Variable wdphi1=15
	Variable wdteta=20
	Variable wbins=36
	string Weight=""
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wphi1, "Phi (deg)"
	Prompt wdphi1, "Opening angle (deg)"
	Prompt wdteta, "1rst particle opening theta angle"
	Prompt wbins, " Binning (number)"
	Prompt Weight, "Additional filter (wave name)"
	duplicate/O phi_e2 phi2_vert
		//Variable pxemax=20
	//Prompt pxemax, " Px Max"
	
	string particle1="e1" // allow  permutation  e1<-> e2
	string particle2="e2"

	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start Tim_Vert_Tim procedure ============="
	timerRefNum = startMSTimer
	TDCS_Vert_T(wenergie1,wdenergie1,wenergie2,wdenergie2,wphi1,wdphi1, wdteta,wbins,weight)
	 hist1 phi2_vert,wtot,(wbins),0,(pi),1,0,0
	 microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
End Macro 

function TDCS_Vert_T(wenergie1,wdenergie1,wenergie2,wdenergie2,wphi1,wdphi1, wdteta,wbins,weight)
	//Variable pxemax=20
	Variable wenergie1
	Variable  wdenergie1
	Variable wenergie2
	Variable wdenergie2
	Variable wphi1
	Variable wdphi1
	Variable wdteta
	Variable wbins
	String weight
	
	WAVE pxe1=px_e1
	WAVE pye1=py_e1
	WAVE pze1=pz_e1
	WAVE ee1=e_e1
	WAVE pxe2=px_e2
	WAVE pye2=py_e2
	WAVE pze2=pz_e2
	WAVE ee2=e_e2
	duplicate/O pxe1, w1,w2,wtot
	
	//w1=(abs(pxe1<pxemax)&&(abs(pxe2)<pxemax))
	SelectEnergy("e1",wenergie1,wdenergie1,w1)
	OrientLight("e1",pi/2,wdteta*pi/180, wphi1*pi/180, wdphi1*pi/180,w1)   // Orientation filter electron 1
	SelectEnergy("e2",wenergie2,wdenergie2,w2)
	OrientLight("e2",pi/2,wdteta*pi/180, 0, 2*pi,w2)	// Orientation filter electron 2
	wtot=w1*w2
	if (cmpstr(weight,""))   // Is there any weight filter to include (ions?)
		WAVE wion=$(weight)
		wtot=w1*w2*wion
	else
		wtot=w1*w2
	endif
	

End

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN_MOL   22/05/05
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//cette macro permet de visualiser la distribution  teta2 pondre,
//pour un couple (teta1, E1) donn, et ceci dans le plan (k1, champ E) . La molecule est dans le meme plan avec un angle tetai. Attention tetai=0 est un cas spcial. Changer la ligne correspondante.
Macro MacroTDCS_plan_mol(wteta1,wdteta1,wphi1,wdphi1,wenergie1,wdenergie1,wenergie2,wdenergie2,wtetai, wdtetai)
	Variable wteta1=90
	Variable wdteta1=15// (idem Allemands...)
	Variable wphi1=-90
	Variable wdphi1=15
	Variable wenergie1=12.5
	Variable wdenergie1=10
	Variable wenergie2=12.5
	Variable wdenergie2=10
	Variable wtetai=90
	Variable wdtetai=12
	Prompt wteta1, "1rst particle : theta (deg)"
	Prompt wdteta1, " Opening angle  (deg)"
	Prompt wphi1, "Phi (deg)"
	Prompt wdphi1, "Opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wtetai, "ion 1: theta (deg)"
	Prompt wdtetai, " Opening angle  (deg)"
	
	string particle1="e1" // allow  permutation  e1<-> e2
	string particle2="e2"
	Variable dpe=20		// delta phi entre electron 1 et electron 2
	Variable dpi=45		// delta phi entre electron 1 et ion 1
	Variable wbins=36

	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS Plan procedure ============="
	timerRefNum = startMSTimer

	// Calcul Filter	
	duplicate/O/D $("thet_"+particle1), wa,wb, w1, w2,wtot,wi
		// Electron 1 Filter
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)												// Energy filter
		OrientLight(particle1,wteta1*pi/180,wdteta1*pi/180, wphi1*pi/180, wdphi1*pi/180,w1)	// Orientation filter
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)						// Energy filter
		wa=((abs($("Dphi_"+particle1+particle2))<dpe*pi/180 )%| (abs(abs($("Dphi_"+particle1+particle2))-2*pi)<dpe*pi/180))  // angle filter, same half planes
		wb= (abs(abs($("Dphi_"+particle1+particle2))-pi)<dpe*pi/180)  // angle filter, opposite half planes
		wtot=(wa+wb)*w1*w2
		
		wtot=wtot*(((abs(phi_i1-phi_e1)<dpi*pi/180)%&(abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180))%| ((abs(phi_i2-phi_e1)<dpi*pi/180)%&(abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180)))
		
	      // special case , SIGMA
	      
	      //wtot=wtot*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%| (abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180))
		
	       
	// Make TDCS Plan   
		duplicate/O/D $("thet_"+particle2), wtet2
		// Convert particle2 spherical angle (0,Pi) into trigonometrical angle (0,2Pi)
		wtet2=wtet2*wa+(2*Pi-wtet2)*wb
		// Do histogram
		hist1 wtet2,wtot,(wbins),0.,(2*pi),0,0,0
		ponder1D(Hist_wtet2)  
		duplicate/O/D  Hist_wtet2_pond Hist_wtet2_pond_D     //08/01/05
 	killwaves w1,w2,wa,wb, wtot,wtet2,wi
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN_inv_MOL   22/05/05
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//cette macro permet de visualiser la distribution  teta2 pondre,
//pour un couple (teta1, E1) donn, et ceci dans le plan (k1, champ E) . La molecule est dans le meme plan avec un angle tetai. Attention tetai=0 est un cas spcial. Changer la ligne correspondante.
Macro MacroTDCS_plan_inv_mol(wteta1,wdteta1,wphi1,wdphi1,wenergie1,wdenergie1,wenergie2,wdenergie2,wtetai, wdtetai)
	Variable wteta1=90
	Variable wdteta1=15// (idem Allemands...)
	Variable wphi1=-90
	Variable wdphi1=15
	Variable wenergie1=12.5
	Variable wdenergie1=10
	Variable wenergie2=12.5
	Variable wdenergie2=10
	Variable wtetai=90
	Variable wdtetai=12
	Prompt wteta1, "1rst particle : theta (deg)"
	Prompt wdteta1, " Opening angle  (deg)"
	Prompt wphi1, "Phi (deg)"
	Prompt wdphi1, "Opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wtetai, "ion 1: theta (deg)"
	Prompt wdtetai, " Opening angle  (deg)"
	
	string particle1="e2" // allow  permutation  e1<-> e2
	string particle2="e1"
	Variable dpe=20		// delta phi entre electron 1 et electron 2
	Variable dpi=45		// delta phi entre electron 1 et ion 1
	Variable wbins=36

	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS Plan procedure ============="
	timerRefNum = startMSTimer

	// Calcul Filter	
	duplicate/O/D $("thet_"+particle1), wa,wb, w1, w2,wtot,wi
		// Electron 1 Filter
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)												// Energy filter
		OrientLight(particle1,wteta1*pi/180,wdteta1*pi/180, wphi1*pi/180, wdphi1*pi/180,w1)	// Orientation filter
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)						// Energy filter
		wa=((abs($("Dphi_"+particle1+particle2))<dpe*pi/180 )%| (abs(abs($("Dphi_"+particle1+particle2))-2*pi)<dpe*pi/180))  // angle filter, same half planes
		wb= (abs(abs($("Dphi_"+particle1+particle2))-pi)<dpe*pi/180)  // angle filter, opposite half planes
		wtot=(wa+wb)*w1*w2
		
		// orientation of the molecule
		wtot=wtot*(((abs(phi_i1-phi_e1)<dpi*pi/180)%&(abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180))%| ((abs(phi_i2-phi_e1)<dpi*pi/180)%&(abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180)))
		
	    // special case , SIGMA
	      
	      //wtot=wtot*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%| (abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180))  
	       
	// Make TDCS Plan   
		duplicate/O/D $("thet_"+particle2), wtet2
		// Convert particle2 spherical angle (0,Pi) into trigonometrical angle (0,2Pi)
		wtet2=wtet2*wa+(2*Pi-wtet2)*wb
		// Do histogram
		hist1 wtet2,wtot,(wbins),0.,(2*pi),0,0,0
		ponder1D(Hist_wtet2)  
		duplicate/O/D Hist_wtet2_pond  Hist_wtet2_pond_I,Hist_wtet2_pond_Tot
		Hist_wtet2_pond_Tot=Hist_wtet2_pond_D + Hist_wtet2_pond_I
 	killwaves w1,w2,wa,wb, wtot,wtet2
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN_MOL_perp   25/05/05
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//cette macro permet de visualiser la distribution  teta2 pondre,
//pour un couple (teta1, E1) donn, et ceci dans le plan (k1, champ E) . La molecule est dans le plan perpendiculaire avec un angle polaire tetai.
Macro MacroTDCS_plan_mol_perp(wteta1,wdteta1,wphi1,wdphi1,wenergie1,wdenergie1,wenergie2,wdenergie2,wtetai, wdtetai)
	Variable wteta1=90
	Variable wdteta1=15// (idem Allemands...)
	Variable wphi1=-90
	Variable wdphi1=15
	Variable wenergie1=12.5
	Variable wdenergie1=10
	Variable wenergie2=12.5
	Variable wdenergie2=10
	Variable wtetai=90
	Variable wdtetai=12
	Prompt wteta1, "1rst particle : theta (deg)"
	Prompt wdteta1, " Opening angle  (deg)"
	Prompt wphi1, "Phi (deg)"
	Prompt wdphi1, "Opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wtetai, "ion 1: theta (deg)"
	Prompt wdtetai, " Opening angle  (deg)"
	
	string particle1="e1" // allow  permutation  e1<-> e2
	string particle2="e2"
	Variable dpe=20		// delta phi entre electron 1 et electron 2
	Variable dpi=45		// delta phi entre electron 1 et ion 1
	Variable wbins=36

	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS Plan procedure ============="
	timerRefNum = startMSTimer

	// Calcul Filter	
	duplicate/O/D $("thet_"+particle1), wa,wb, w1, w2,wtot,wi
		// Electron 1 Filter
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)												// Energy filter
		OrientLight(particle1,wteta1*pi/180,wdteta1*pi/180, wphi1*pi/180, wdphi1*pi/180,w1)	// Orientation filter
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)						// Energy filter
		wa=((abs($("Dphi_"+particle1+particle2))<dpe*pi/180 )%| (abs(abs($("Dphi_"+particle1+particle2))-2*pi)<dpe*pi/180))  // angle filter, same half planes
		wb= (abs(abs($("Dphi_"+particle1+particle2))-pi)<dpe*pi/180)  // angle filter, opposite half planes
		wtot=(wa+wb)*w1*w2
		
		// orientation of the molecule
		wtot=wtot*(((abs(abs(phi_i1-phi_e1)-pi/2)<dpi*pi/180)%&(abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180))%| ((abs(abs(phi_i2-phi_e1)-pi/2)<dpi*pi/180)%&(abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180)))
		
	      
	       
	// Make TDCS Plan   
		duplicate/O/D $("thet_"+particle2), wtet2
		// Convert particle2 spherical angle (0,Pi) into trigonometrical angle (0,2Pi)
		wtet2=wtet2*wa+(2*Pi-wtet2)*wb
		// Do histogram
		hist1 wtet2,wtot,(wbins),0.,(2*pi),0,0,0
		ponder1D(Hist_wtet2)  
		duplicate/O/D  Hist_wtet2_pond Hist_wtet2_pond_D     //08/01/05
 	killwaves w1,w2,wa,wb, wtot,wtet2,wi
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro


//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN 0_PI_Mol
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
// La molcule est dans le meme plan que les 2 lectrons, en utilisant l'angle azimutal de l'lectron 2


Macro MacroTDCS_0Pi_Mol(wdteta1,wenergie1,wdenergie1,wenergie2,wdenergie2,wtetai, wdtetai)
	Variable wdteta1=20// (idem Allemands...)
	Variable wenergie1=20
	Variable wdenergie1=5
	Variable wenergie2=5
	Variable wdenergie2=3
	Variable wtetai
	Variable wdtetai
	Prompt wdteta1, "1rst particle : opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wtetai, "ion 1: theta (deg)"
	Prompt wdtetai, " Opening angle  (deg)"
	
	string particle1="e1" // allow  permutation  e1<-> e2
	string particle2="e2"
	Variable wbins=36
	Variable dpi=45
	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS 0-Pi procedure ============="
	timerRefNum = startMSTimer
		
	// Calcul Filter
	duplicate/O/D $("thet_"+particle1), w1,w2, wtot, wtot_pi		
		// Electron 1 Filter		
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)	
		duplicate/O/D w1, w1_pi
		OrientLight(particle1,0,wdteta1*pi/180, 0, 2*pi,w1)
		OrientLight(particle1,Pi,wdteta1*pi/180, 0, 2*pi,w1_pi)	
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)							
		// Full filter
		wtot=w1*w2
		wtot_pi=w1_pi*w2
		
		// orientation of the molecule
		//wtot=wtot*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%&((abs(phi_i1-phi_e2)<dpi*pi/180)%| (abs(phi_i2-phi_e2)<dpi*pi/180)))
		//wtot_pi=wtot_pi*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%&((abs(phi_i1-phi_e2)<dpi*pi/180)%| (abs(phi_i2-phi_e2)<dpi*pi/180)))
		
		// cas spcial SIGMA
		wtot=wtot*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%| (abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180)) 
	       wtot_pi=wtot_pi*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%| (abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180)) 
	       
        // Make TDCS 0-Pi   
	duplicate/O/D $("thet_"+particle2), wtet2, wtet2_pi
	
	hist1 wtet2,wtot,(wbins),0,(pi),0,0,0
	hist1 wtet2_pi,wtot_pi,(wbins),0,(pi),0,0,0
	InvertSum(Hist_wtet2,Hist_wtet2_pi)
	//Hist_wtet2=Hist_wtet2_pi
	Ponder1D(Hist_wtet2)       
	duplicate /O/D Hist_wtet2_pond Hist_wtet2_pond_D
 	killwaves w1,w1_pi,w2,wtot,wtot_pi,wtet2,wtet2_pi,Hist_wtet2_pi
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro


//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN 0_PI_inv_Mol
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
// indem mais avec inversion des 2 lectrons


Macro MacroTDCS_0Pi_inv_Mol(wdteta1,wenergie1,wdenergie1,wenergie2,wdenergie2,wtetai, wdtetai)
	Variable wdteta1=20// (idem Allemands...)
	Variable wenergie1=20
	Variable wdenergie1=5
	Variable wenergie2=5
	Variable wdenergie2=3
	Variable wtetai
	Variable wdtetai
	Prompt wdteta1, "1rst particle : opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wtetai, "ion 1: theta (deg)"
	Prompt wdtetai, " Opening angle  (deg)"
	
	string particle1="e2" // allow  permutation  e1<-> e2
	string particle2="e1"
	Variable wbins=36
	Variable dpi=45
	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS 0-Pi procedure ============="
	timerRefNum = startMSTimer
		
	// Calcul Filter
	duplicate/O/D $("thet_"+particle1), w1,w2, wtot, wtot_pi		
		// Electron 1 Filter		
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)	
		duplicate/O/D w1, w1_pi
		OrientLight(particle1,0,wdteta1*pi/180, 0, 2*pi,w1)
		OrientLight(particle1,Pi,wdteta1*pi/180, 0, 2*pi,w1_pi)	
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)							
		// Full filter
		wtot=w1*w2
		wtot_pi=w1_pi*w2
		
		// orientation of the molecule
		//wtot=wtot*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%&((abs(phi_i1-phi_e2)<dpi*pi/180)%| (abs(phi_i2-phi_e2)<dpi*pi/180)))
		//wtot_pi=wtot_pi*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%&((abs(phi_i1-phi_e2)<dpi*pi/180)%| (abs(phi_i2-phi_e2)<dpi*pi/180)))
		
		// cas spcial SIGMA
		wtot=wtot*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%| (abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180)) 
	       wtot_pi=wtot_pi*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%| (abs(thet_i2-wtetai*pi/180)<wdtetai*pi/180)) 
	       
        // Make TDCS 0-Pi   
	duplicate/O/D $("thet_"+particle2), wtet2, wtet2_pi
	
	hist1 wtet2,wtot,(wbins),0,(pi),0,0,0
	hist1 wtet2_pi,wtot_pi,(wbins),0,(pi),0,0,0
	InvertSum(Hist_wtet2,Hist_wtet2_pi)
	//Hist_wtet2=Hist_wtet2_pi
	Ponder1D(Hist_wtet2)       
	duplicate/O/D Hist_wtet2_pond  Hist_wtet2_pond_I,Hist_wtet2_pond_Tot
		Hist_wtet2_pond_Tot=Hist_wtet2_pond_D + Hist_wtet2_pond_I
 	killwaves w1,w1_pi,w2,wtot,wtot_pi,wtet2,wtet2_pi,Hist_wtet2_pi
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												TDCS PLAN 0PI_Mol_perp
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
// La molcule est dans leplan perpendiculaire  celui des 2 lectrons, en utilisant l'angle azimutal de l'lectron 2

Macro MacroTDCS_0Pi_Mol_perp(wdteta1,wenergie1,wdenergie1,wenergie2,wdenergie2,wtetai, wdtetai)
	Variable wdteta1=20// (idem Allemands...)
	Variable wenergie1=20
	Variable wdenergie1=5
	Variable wenergie2=5
	Variable wdenergie2=3
	Variable wtetai
	Variable wdtetai
	Prompt wdteta1, "1rst particle : opening angle (deg)"
	Prompt wenergie1, "Mean energy (eV)"
	Prompt wdenergie1, "dE (eV)"
	Prompt wenergie2, "2nd particle: Mean energy (eV)"
	Prompt wdenergie2, "dE (eV)"
	Prompt wtetai, "ion 1: theta (deg)"
	Prompt wdtetai, " Opening angle  (deg)"
	
	string particle1="e1" // allow  permutation  e1<-> e2
	string particle2="e2"
	Variable wbins=36
	Variable dpi=45
	Variable timerRefNum, microSeconds	
	Silent 1; DelayUpdate
	Print "============= Start TDCS 0-Pi procedure ============="
	timerRefNum = startMSTimer
		
	// Calcul Filter
	duplicate/O/D $("thet_"+particle1), w1,w2, wtot, wtot_pi		
		// Electron 1 Filter		
		SelectEnergy(particle1,wenergie1,wdenergie1,w1)	
		duplicate/O/D w1, w1_pi
		OrientLight(particle1,0,wdteta1*pi/180, 0, 2*pi,w1)
		OrientLight(particle1,Pi,wdteta1*pi/180, 0, 2*pi,w1_pi)	
		// Electron 2 Filter
		SelectEnergy(particle2,wenergie2,wdenergie2,w2)							
		// Full filter
		wtot=w1*w2
		wtot_pi=w1_pi*w2
		
		// orientation of the molecule
		wtot=wtot*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%&((abs(abs(phi_i1-phi_e2)-pi/2)<dpi*pi/180)%| (abs(abs(phi_i2-phi_e2)-pi/2)<dpi*pi/180)))
		wtot_pi=wtot_pi*((abs(thet_i1-wtetai*pi/180)<wdtetai*pi/180)%&((abs(abs(phi_i1-phi_e2)-pi/2)<dpi*pi/180)%| (abs(abs(phi_i2-phi_e2)-pi/2)<dpi*pi/180)))
	       
        // Make TDCS 0-Pi   
	duplicate/O/D $("thet_"+particle2), wtet2, wtet2_pi
	
	hist1 wtet2,wtot,(wbins),0,(pi),0,0,0
	hist1 wtet2_pi,wtot_pi,(wbins),0,(pi),0,0,0
	InvertSum(Hist_wtet2,Hist_wtet2_pi)
	//Hist_wtet2=Hist_wtet2_pi
	Ponder1D(Hist_wtet2)       

 	killwaves w1,w1_pi,w2,wtot,wtot_pi,wtet2,wtet2_pi,Hist_wtet2_pi
 	microSeconds = stopMSTimer(timerRefNum)	
	Print "TDCS Elapse Time (Sec)=", microSeconds/1e6
Endmacro